VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   6210
   ClientLeft      =   1335
   ClientTop       =   1560
   ClientWidth     =   5220
   Height          =   6615
   Icon            =   "frmMain.frx":0000
   Left            =   1275
   LinkTopic       =   "Form1"
   ScaleHeight     =   6210
   ScaleWidth      =   5220
   Top             =   1215
   Width           =   5340
   Begin VB.CommandButton cmdAIMultiChanScan 
      Caption         =   "Scan AI Chan 0 .. 3"
      Height          =   375
      Left            =   720
      TabIndex        =   6
      Top             =   2520
      Width           =   1815
   End
   Begin VB.ListBox List1 
      Height          =   2400
      Left            =   2880
      TabIndex        =   5
      Top             =   1800
      Width           =   1215
   End
   Begin VB.CommandButton cmdAIScan 
      Caption         =   "Scan AI Channel 0"
      Height          =   375
      Left            =   720
      TabIndex        =   4
      Top             =   1800
      Width           =   1815
   End
   Begin VB.CommandButton cmdPolledAI 
      Caption         =   "Sample AI Channel 0"
      Height          =   375
      Left            =   720
      TabIndex        =   1
      Top             =   960
      Width           =   1815
   End
   Begin VB.Label Label2 
      Caption         =   "Average Value:"
      Height          =   255
      Left            =   840
      TabIndex        =   8
      Top             =   3240
      Width           =   1335
   End
   Begin VB.Label lblAverage 
      BackColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   960
      TabIndex        =   7
      Top             =   3720
      Width           =   1215
   End
   Begin VB.Label lblPolled 
      BackColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   2760
      TabIndex        =   3
      Top             =   1080
      Width           =   735
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   13.5
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   720
      TabIndex        =   2
      Top             =   240
      Width           =   1845
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H00FFFFFF&
      Height          =   255
      Left            =   600
      TabIndex        =   0
      Top             =   4560
      Width           =   3855
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   600
      Top             =   5160
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SRAI 
      Left            =   1200
      Top             =   5160
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdAIMultiChanScan_Click()
List1.Clear  ' clear list box
cmdAIScan.Enabled = False  'disable other buttons until finished
cmdAIMultiChanScan.Enabled = False
With SRAI
.Req_subsystem = DL_AI  ' use AI subsystem
.Req_mode = DL_DMA      ' use DMA mode
.Req_op = DL_START      ' this is start operation
.Evt_Str_type = DL_COMMAND  ' start on command
.Evt_Stp_type = DL_TCEVENT  ' stop when buffer is full
' specify the speed of the DMA data capture
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = DL_DEFAULTTIMER
.Evt_Tim_rateMode = DL_RATEGEN
.Evt_Tim_rateClock = DL_INTERNAL1
.Evt_Tim_rateGate = DL_DISABLED
' below line programs it for 1000 Hz
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 1000)
' ********  Select Group ***************
.Sel_chan_format = DL_tNATIVE
.Sel_chan_N = 2  ' a start/stop range of channels will be specified
.Sel_chan_start = 0                        ' start at channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' bipolar gain of 1 for start channel
.Sel_chan_stop = 3  ' stop at chan 3 for 4 channels total....0 through 3
.Sel_chan_stopGainCode = .DLGain2Code(-1)  ' use this gain for all channels except start chan
.Sel_buf_N = 1   ' one buffer
.Sel_buf_samples = 100   ' 100 data points...buffer samples must be multiple of the # of channels
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
.Refresh  ' do it
End With
lblStatus.Caption = SRAI.Message  ' display status
End Sub

Private Sub cmdAIScan_Click()
List1.Clear  ' clear list box
cmdAIScan.Enabled = False  'disable other buttons until finished
cmdAIMultiChanScan.Enabled = False
With SRAI
.Req_subsystem = DL_AI  ' use AI subsystem
.Req_mode = DL_DMA      ' use DMA mode
.Req_op = DL_START      ' this is start operation
.Evt_Str_type = DL_COMMAND  ' start on command
.Evt_Stp_type = DL_TCEVENT  ' stop when buffer is full
' specify the speed of the DMA data capture
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = DL_DEFAULTTIMER
.Evt_Tim_rateMode = DL_RATEGEN
.Evt_Tim_rateClock = DL_INTERNAL1
.Evt_Tim_rateGate = DL_DISABLED
' below line programs it for 1000 Hz
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 1000)
' ********  Select Group ***************
.Sel_chan_format = DL_tNATIVE
.Sel_chan_N = 1  ' just one channel will be specified
.Sel_chan_start = 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' bipolar gain of 1
.Sel_chan_stop = 0  ' stop chan = start chan = single channel
.Sel_chan_stopGainCode = .DLGain2Code(-1)
.Sel_buf_N = 1   ' one buffer
.Sel_buf_samples = 100   ' 100 data points
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
.Refresh  ' do it
End With
lblStatus.Caption = SRAI.Message  ' display status
End Sub


Private Sub cmdPolledAI_Click()
List1.Clear
lblAverage.Caption = ""
With SRAI
.Req_mode = DL_POLLED
.Req_op = DL_START
.Req_subsystem = DL_AI
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_TCEVENT
.Evt_Tim_type = DL_NULLEVENT
.Res_Sta_typeStatus = DL_IOVALUE
.Sel_buf_N = 0
.Sel_buf_samples = 0
.Sel_buf_notify = DL_NOEVENTS
.Sel_chan_N = 1
.Sel_chan_start = 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' bipolar, gain of 1
' two lines below will invoke the LearnDL Dialog so
' you can see how the Service Request has been set up.
'.Req_op_edit = True
'.Refresh
.Refresh  ' carry out the task, e.g., read the channel

lblStatus.Caption = "Analog Input Status: " & .Message
lblPolled.Caption = Format(.DLCode2Volts(.Res_Sta_ioValue), "#0.###0")
End With
' get the polled mode value from .Res_Sta_ioValue property
' convert it from raw codes to volts and then display it in label

' NOTE:  the DLCode2Volts method is not gain aware.  It always
' assums bipolar gain of 1.  Use VBArrayBufferConvert to have
' gain aware conversion, or just do math transform on the results
' to take care of your gain other than bipolar and 1
End Sub

Private Sub Form_Load()
With SRAI
.Req_DLL_name = "c:\drvlinx4\kmbdas16.dll"  ' Open the driver
'
' Initialize the device
.Req_device = 0  ' the device number assigned in kmbdas16.ini
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Req_mode = DL_OTHER
.Refresh
End With
' error check
If SRAI.Res_result <> DL_NoErr Then
lblStatus.Caption = SRAI.Message
Else
lblStatus.Caption = "Initialized with " & SRAI.Message
LDD.Req_DLL_name = SRAI.Req_DLL_name
LDD.device = SRAI.Req_device
LDD.Refresh
Form1.Caption = "DriverLINX and " & LDD.Dev_Model
End If

End Sub


Private Sub Form_Unload(Cancel As Integer)
' unload the driver
SRAI.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub


Private Sub SRAI_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
' program execution comes here automatically when DLinx sends the buffer is full
' message to this application
Dim dummy As Single
Dim volts(100) As Single  ' same size as SR.Sel_buf_samples property
Dim average As Double
Dim i As Integer

'convert 100 pts to volts and move to the volts() array
dummy = SRAI.VBArrayBufferConvert(bufIndex, 0, 100, volts, DL_tSINGLE, 0, 0)

' dummy will equal 0 if Convert operation was successful

For i = 0 To 99
average = average + volts(i)
Next i
average = average / 100
lblAverage.Caption = Format(average, "#0.###0")
' display 12 points in the list box
For i = 0 To 11
List1.AddItem Format(volts(i), "#0.###0")
Next i
' for the multi channel scan case, the data in the buffer will be from channel
' 0,1,2,3,0,1,2,3,etc....
'
lblStatus.Caption = "Data have been aquired"
cmdAIScan.Enabled = True  ' allow the acquire buttons to be pushed again
cmdAIMultiChanScan.Enabled = True
End Sub


